@extends('admin.layouts.app')

@section('title', 'Data Cuti')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">Data Cuti</h4>
            <small class="text-muted">Manajemen data cuti</small>
        </div>
        {{-- <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahKaryawan">
            <i class="fas fa-plus me-2"></i>Tambah Data
        </button> --}}
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nama</th>
                        <th>Tanggal Mulai</th>
                        <th>Tanggal Selesai</th>
                        <th>Alasan</th>
                        <th>Status</th>
                        <th>Catatan</th>
                        {{-- <th class="text-center">Aksi</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cuti as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->karyawan->user->nama ?? '-' }}</td>
                            <td>{{ $item->tanggal_mulai ?? '-' }}</td>
                            <td>{{ $item->tanggal_selesai ?? '-' }}</td>
                            <td>{{ $item->alasan ?? '-' }}</td>
                            <td>
                                <span class="badge {{ $item->status == 'hadir' ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $item->status }}
                                </span>
                            </td>
                            <td>{{ $item->catatan_admin ?? '-' }}</td>

                            {{-- <td class="text-center">
                                @if ($item->status == 'pending')
                                    <form action="{{ route('admin.cuti.approve', $item->id) }}" method="POST"
                                        style="display:inline">
                                        @csrf
                                        <button class="btn btn-success btn-sm">Approve</button>
                                    </form>

                                    <form action="{{ route('admin.cuti.reject', $item->id) }}" method="POST"
                                        style="display:inline">
                                        @csrf
                                        <button class="btn btn-danger btn-sm">Reject</button>
                                        <input type="text" name="catatan_admin" placeholder="Alasan penolakan (opsional)">
                                    </form>
                                @else
                                    <em>Sudah diproses</em>
                                @endif
                            </td> --}}
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        @foreach ($cuti as $item)
            {{-- @include('admin.karyawan.edit')
            @include('admin.karyawan.delete') --}}
        @endforeach
    </div>
    {{-- @include('admin.karyawan.create') --}}


@endsection
